@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property fileSystemConfig The URL where the Git repository is located. See File System Config details below.
 * @property kernelSpec The default branch for the Git repository. See Kernel Spec details below.
 */
public data class AppImageConfigKernelGatewayImageConfig(
    public val fileSystemConfig: AppImageConfigKernelGatewayImageConfigFileSystemConfig? = null,
    public val kernelSpec: AppImageConfigKernelGatewayImageConfigKernelSpec,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.AppImageConfigKernelGatewayImageConfig):
            AppImageConfigKernelGatewayImageConfig = AppImageConfigKernelGatewayImageConfig(
            fileSystemConfig = javaType.fileSystemConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigKernelGatewayImageConfigFileSystemConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelSpec = javaType.kernelSpec().let({ args0 ->
                com.pulumi.aws.sagemaker.kotlin.outputs.AppImageConfigKernelGatewayImageConfigKernelSpec.Companion.toKotlin(args0)
            }),
        )
    }
}
