@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultGid The default POSIX group ID (GID). If not specified, defaults to `100`. Valid values are `0` and `100`.
 * @property defaultUid The default POSIX user ID (UID). If not specified, defaults to `1000`. Valid values are `0` and `1000`.
 * @property mountPath The path within the image to mount the user's EFS home directory. The directory should be empty. If not specified, defaults to `/home/sagemaker-user`.
 * > **Note:** When specifying `default_gid` and `default_uid`, Valid value pairs are [`0`, `0`] and [`100`, `1000`].
 */
public data class AppImageConfigKernelGatewayImageConfigFileSystemConfig(
    public val defaultGid: Int? = null,
    public val defaultUid: Int? = null,
    public val mountPath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.AppImageConfigKernelGatewayImageConfigFileSystemConfig):
            AppImageConfigKernelGatewayImageConfigFileSystemConfig =
            AppImageConfigKernelGatewayImageConfigFileSystemConfig(
                defaultGid = javaType.defaultGid().map({ args0 -> args0 }).orElse(null),
                defaultUid = javaType.defaultUid().map({ args0 -> args0 }).orElse(null),
                mountPath = javaType.mountPath().map({ args0 -> args0 }).orElse(null),
            )
    }
}
