@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataCapturedDestinationS3Uri The Amazon S3 location being used to capture the data.
 * @property datasetFormat The dataset format for your batch transform job. Fields are documented below.
 * @property localPath Path to the filesystem where the batch transform data is available to the container. Defaults to `/opt/ml/processing/input`.
 * @property s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
 * @property s3InputMode Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
 */
public data class DataQualityJobDefinitionDataQualityJobInputBatchTransformInput(
    public val dataCapturedDestinationS3Uri: String,
    public val datasetFormat:
    DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormat,
    public val localPath: String? = null,
    public val s3DataDistributionType: String? = null,
    public val s3InputMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInput):
            DataQualityJobDefinitionDataQualityJobInputBatchTransformInput =
            DataQualityJobDefinitionDataQualityJobInputBatchTransformInput(
                dataCapturedDestinationS3Uri = javaType.dataCapturedDestinationS3Uri(),
                datasetFormat = javaType.datasetFormat().let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionDataQualityJobInputBatchTransformInputDatasetFormat.Companion.toKotlin(args0)
                }),
                localPath = javaType.localPath().map({ args0 -> args0 }).orElse(null),
                s3DataDistributionType = javaType.s3DataDistributionType().map({ args0 -> args0 }).orElse(null),
                s3InputMode = javaType.s3InputMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
