@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property endpointName An endpoint in customer's account which has `data_capture_config` enabled.
 * @property localPath Path to the filesystem where the endpoint data is available to the container. Defaults to `/opt/ml/processing/input`.
 * @property s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
 * @property s3InputMode Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
 */
public data class DataQualityJobDefinitionDataQualityJobInputEndpointInput(
    public val endpointName: String,
    public val localPath: String? = null,
    public val s3DataDistributionType: String? = null,
    public val s3InputMode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionDataQualityJobInputEndpointInput):
            DataQualityJobDefinitionDataQualityJobInputEndpointInput =
            DataQualityJobDefinitionDataQualityJobInputEndpointInput(
                endpointName = javaType.endpointName(),
                localPath = javaType.localPath().map({ args0 -> args0 }).orElse(null),
                s3DataDistributionType = javaType.s3DataDistributionType().map({ args0 -> args0 }).orElse(null),
                s3InputMode = javaType.s3InputMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
