@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property enableInterContainerTrafficEncryption Whether to encrypt all communications between the instances used for the monitoring jobs. Choose `true` to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.
 * @property enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.
 * @property vpcConfig Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. Fields are documented below.
 */
public data class DataQualityJobDefinitionNetworkConfig(
    public val enableInterContainerTrafficEncryption: Boolean? = null,
    public val enableNetworkIsolation: Boolean? = null,
    public val vpcConfig: DataQualityJobDefinitionNetworkConfigVpcConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionNetworkConfig):
            DataQualityJobDefinitionNetworkConfig = DataQualityJobDefinitionNetworkConfig(
            enableInterContainerTrafficEncryption = javaType.enableInterContainerTrafficEncryption().map({ args0 ->
                args0
            }).orElse(null),
            enableNetworkIsolation = javaType.enableNetworkIsolation().map({ args0 -> args0 }).orElse(null),
            vpcConfig = javaType.vpcConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DataQualityJobDefinitionNetworkConfigVpcConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
