@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. Specify the security groups for the VPC that is specified in the `subnets` field.
 * @property subnets The ID of the subnets in the VPC to which you want to connect your training job or model.
 */
public data class DataQualityJobDefinitionNetworkConfigVpcConfig(
    public val securityGroupIds: List<String>,
    public val subnets: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DataQualityJobDefinitionNetworkConfigVpcConfig):
            DataQualityJobDefinitionNetworkConfigVpcConfig =
            DataQualityJobDefinitionNetworkConfigVpcConfig(
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnets = javaType.subnets().map({ args0 -> args0 }),
            )
    }
}
