@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
 * @property s3OutputLocation The Amazon Simple Storage (S3) bucker URI.
 */
public data class DeviceFleetOutputConfig(
    public val kmsKeyId: String? = null,
    public val s3OutputLocation: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DeviceFleetOutputConfig):
            DeviceFleetOutputConfig = DeviceFleetOutputConfig(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            s3OutputLocation = javaType.s3OutputLocation(),
        )
    }
}
