@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property canvasAppSettings The Canvas app settings. See Canvas App Settings below.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property rSessionAppSettings The RSession app settings. See RSession App Settings below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
 * @property securityGroups A list of security group IDs that will be attached to the user.
 * @property sharingSettings The sharing settings. See Sharing Settings below.
 * @property tensorBoardAppSettings The TensorBoard app settings. See TensorBoard App Settings below.
 */
public data class DomainDefaultUserSettings(
    public val canvasAppSettings: DomainDefaultUserSettingsCanvasAppSettings? = null,
    public val executionRole: String,
    public val jupyterServerAppSettings: DomainDefaultUserSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: DomainDefaultUserSettingsKernelGatewayAppSettings? = null,
    public val rSessionAppSettings: DomainDefaultUserSettingsRSessionAppSettings? = null,
    public val rStudioServerProAppSettings: DomainDefaultUserSettingsRStudioServerProAppSettings? =
        null,
    public val securityGroups: List<String>? = null,
    public val sharingSettings: DomainDefaultUserSettingsSharingSettings? = null,
    public val tensorBoardAppSettings: DomainDefaultUserSettingsTensorBoardAppSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettings):
            DomainDefaultUserSettings = DomainDefaultUserSettings(
            canvasAppSettings = javaType.canvasAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsCanvasAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            executionRole = javaType.executionRole(),
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rSessionAppSettings = javaType.rSessionAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsRSessionAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rStudioServerProAppSettings = javaType.rStudioServerProAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsRStudioServerProAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            sharingSettings = javaType.sharingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsSharingSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tensorBoardAppSettings = javaType.tensorBoardAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsTensorBoardAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
