@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataSourceName The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud. Valid values are `SalesforceGenie` and `Snowflake`.
 * @property secretArn The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider, such as the client ID and secret, authorization URL, and token URL.
 * @property status Describes whether OAuth for a data source is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSetting(
    public val dataSourceName: String? = null,
    public val secretArn: String,
    public val status: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSetting):
            DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSetting =
            DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSetting(
                dataSourceName = javaType.dataSourceName().map({ args0 -> args0 }).orElse(null),
                secretArn = javaType.secretArn(),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
            )
    }
}
