@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultUserSettingsKernelGatewayAppSettings(
    public val customImages: List<DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage>? =
        null,
    public val defaultResourceSpec:
    DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec? = null,
    public val lifecycleConfigArns: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainDefaultUserSettingsKernelGatewayAppSettings):
            DomainDefaultUserSettingsKernelGatewayAppSettings =
            DomainDefaultUserSettingsKernelGatewayAppSettings(
                customImages = javaType.customImages().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsKernelGatewayAppSettingsCustomImage.Companion.toKotlin(args0)
                    })
                }),
                defaultResourceSpec = javaType.defaultResourceSpec().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.DomainDefaultUserSettingsKernelGatewayAppSettingsDefaultResourceSpec.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lifecycleConfigArns = javaType.lifecycleConfigArns().map({ args0 -> args0 }),
            )
    }
}
