@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property homeEfsFileSystem The retention policy for data stored on an Amazon Elastic File System (EFS) volume. Valid values are `Retain` or `Delete`.  Default value is `Retain`.
 */
public data class DomainRetentionPolicy(
    public val homeEfsFileSystem: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.DomainRetentionPolicy):
            DomainRetentionPolicy = DomainRetentionPolicy(
            homeEfsFileSystem = javaType.homeEfsFileSystem().map({ args0 -> args0 }).orElse(null),
        )
    }
}
