@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property clientConfig Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.
 * @property outputConfig Specifies the configuration for asynchronous inference invocation outputs.
 */
public data class EndpointConfigurationAsyncInferenceConfig(
    public val clientConfig: EndpointConfigurationAsyncInferenceConfigClientConfig? = null,
    public val outputConfig: EndpointConfigurationAsyncInferenceConfigOutputConfig,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationAsyncInferenceConfig):
            EndpointConfigurationAsyncInferenceConfig = EndpointConfigurationAsyncInferenceConfig(
            clientConfig = javaType.clientConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationAsyncInferenceConfigClientConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outputConfig = javaType.outputConfig().let({ args0 ->
                com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationAsyncInferenceConfigOutputConfig.Companion.toKotlin(args0)
            }),
        )
    }
}
