@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maxConcurrentInvocationsPerInstance The maximum number of concurrent requests sent by the SageMaker client to the model container. If no value is provided, Amazon SageMaker will choose an optimal value for you.
 */
public data class EndpointConfigurationAsyncInferenceConfigClientConfig(
    public val maxConcurrentInvocationsPerInstance: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationAsyncInferenceConfigClientConfig):
            EndpointConfigurationAsyncInferenceConfigClientConfig =
            EndpointConfigurationAsyncInferenceConfigClientConfig(
                maxConcurrentInvocationsPerInstance = javaType.maxConcurrentInvocationsPerInstance().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
