@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property errorTopic Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent on failure.
 * @property includeInferenceResponseIns The Amazon SNS topics where you want the inference response to be included. Valid values are `SUCCESS_NOTIFICATION_TOPIC` and `ERROR_NOTIFICATION_TOPIC`.
 * @property successTopic Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no notification is sent on success.
 */
public data class EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfig(
    public val errorTopic: String? = null,
    public val includeInferenceResponseIns: List<String>? = null,
    public val successTopic: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfig):
            EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfig =
            EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfig(
                errorTopic = javaType.errorTopic().map({ args0 -> args0 }).orElse(null),
                includeInferenceResponseIns = javaType.includeInferenceResponseIns().map({ args0 -> args0 }),
                successTopic = javaType.successTopic().map({ args0 -> args0 }).orElse(null),
            )
    }
}
