@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property captureContentTypeHeader The content type headers to capture. Fields are documented below.
 * @property captureOptions Specifies what data to capture. Fields are documented below.
 * @property destinationS3Uri The URL for S3 location where the captured data is stored.
 * @property enableCapture Flag to enable data capture. Defaults to `false`.
 * @property initialSamplingPercentage Portion of data to capture. Should be between 0 and 100.
 * @property kmsKeyId Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt the captured data on Amazon S3.
 */
public data class EndpointConfigurationDataCaptureConfig(
    public val captureContentTypeHeader:
    EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader? = null,
    public val captureOptions: List<EndpointConfigurationDataCaptureConfigCaptureOption>,
    public val destinationS3Uri: String,
    public val enableCapture: Boolean? = null,
    public val initialSamplingPercentage: Int,
    public val kmsKeyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointConfigurationDataCaptureConfig):
            EndpointConfigurationDataCaptureConfig = EndpointConfigurationDataCaptureConfig(
            captureContentTypeHeader = javaType.captureContentTypeHeader().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeader.Companion.toKotlin(args0)
                })
            }).orElse(null),
            captureOptions = javaType.captureOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointConfigurationDataCaptureConfigCaptureOption.Companion.toKotlin(args0)
                })
            }),
            destinationS3Uri = javaType.destinationS3Uri(),
            enableCapture = javaType.enableCapture().map({ args0 -> args0 }).orElse(null),
            initialSamplingPercentage = javaType.initialSamplingPercentage(),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
