@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property autoRollbackConfiguration Automatic rollback configuration for handling endpoint deployment failures and recovery. See Auto Rollback Configuration.
 * @property blueGreenUpdatePolicy Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the specified traffic routing configuration. Only one update policy should be used in the deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic shifting by default. See Blue Green Update Config.
 * @property rollingUpdatePolicy Specifies a rolling deployment strategy for updating a SageMaker endpoint. See Rolling Update Policy.
 */
public data class EndpointDeploymentConfig(
    public val autoRollbackConfiguration: EndpointDeploymentConfigAutoRollbackConfiguration? = null,
    public val blueGreenUpdatePolicy: EndpointDeploymentConfigBlueGreenUpdatePolicy? = null,
    public val rollingUpdatePolicy: EndpointDeploymentConfigRollingUpdatePolicy? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointDeploymentConfig):
            EndpointDeploymentConfig = EndpointDeploymentConfig(
            autoRollbackConfiguration = javaType.autoRollbackConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigAutoRollbackConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            blueGreenUpdatePolicy = javaType.blueGreenUpdatePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigBlueGreenUpdatePolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rollingUpdatePolicy = javaType.rollingUpdatePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigRollingUpdatePolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
