@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarms List of CloudWatch alarms in your account that are configured to monitor metrics on an endpoint. If any alarms are tripped during a deployment, SageMaker rolls back the deployment. See Alarms.
 */
public data class EndpointDeploymentConfigAutoRollbackConfiguration(
    public val alarms: List<EndpointDeploymentConfigAutoRollbackConfigurationAlarm>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointDeploymentConfigAutoRollbackConfiguration):
            EndpointDeploymentConfigAutoRollbackConfiguration =
            EndpointDeploymentConfigAutoRollbackConfiguration(
                alarms = javaType.alarms().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigAutoRollbackConfigurationAlarm.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
