@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumExecutionTimeoutInSeconds Maximum execution timeout for the deployment. Note that the timeout value should be larger than the total waiting time specified in `termination_wait_in_seconds` and `wait_interval_in_seconds`. Valid values are between `600` and `14400`.
 * @property terminationWaitInSeconds Additional waiting time in seconds after the completion of an endpoint deployment before terminating the old endpoint fleet. Default is `0`. Valid values are between `0` and `3600`.
 * @property trafficRoutingConfiguration Defines the traffic routing strategy to shift traffic from the old fleet to the new fleet during an endpoint deployment. See Traffic Routing Configuration.
 */
public data class EndpointDeploymentConfigBlueGreenUpdatePolicy(
    public val maximumExecutionTimeoutInSeconds: Int? = null,
    public val terminationWaitInSeconds: Int? = null,
    public val trafficRoutingConfiguration:
    EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfiguration,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointDeploymentConfigBlueGreenUpdatePolicy):
            EndpointDeploymentConfigBlueGreenUpdatePolicy =
            EndpointDeploymentConfigBlueGreenUpdatePolicy(
                maximumExecutionTimeoutInSeconds = javaType.maximumExecutionTimeoutInSeconds().map({ args0 ->
                    args0
                }).orElse(null),
                terminationWaitInSeconds = javaType.terminationWaitInSeconds().map({ args0 -> args0 }).orElse(null),
                trafficRoutingConfiguration = javaType.trafficRoutingConfiguration().let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfiguration.Companion.toKotlin(args0)
                }),
            )
    }
}
