@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property canarySize Batch size for the first step to turn on traffic on the new endpoint fleet. Value must be less than or equal to 50% of the variant's total instance count. See Canary Size.
 * @property linearStepSize Batch size for each step to turn on traffic on the new endpoint fleet. Value must be 10-50% of the variant's total instance count. See Linear Step Size.
 * @property type Traffic routing strategy type. Valid values are: `ALL_AT_ONCE`, `CANARY`, and `LINEAR`.
 * @property waitIntervalInSeconds The waiting time (in seconds) between incremental steps to turn on traffic on the new endpoint fleet. Valid values are between `0` and `3600`.
 */
public data class EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfiguration(
    public val canarySize:
    EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationCanarySize? = null,
    public val linearStepSize:
    EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationLinearStepSize? =
        null,
    public val type: String,
    public val waitIntervalInSeconds: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfiguration):
            EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfiguration =
            EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfiguration(
                canarySize = javaType.canarySize().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationCanarySize.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                linearStepSize = javaType.linearStepSize().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.sagemaker.kotlin.outputs.EndpointDeploymentConfigBlueGreenUpdatePolicyTrafficRoutingConfigurationLinearStepSize.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
                waitIntervalInSeconds = javaType.waitIntervalInSeconds(),
            )
    }
}
