@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dataCatalogConfig The meta data of the Glue table that is autogenerated when an OfflineStore is created. See Data Catalog Config Below.
 * @property disableGlueTableCreation Set to `true` to turn Online Store On.
 * @property s3StorageConfig The Amazon Simple Storage (Amazon S3) location of OfflineStore. See S3 Storage Config Below.
 * @property tableFormat Format for the offline store table. Supported formats are `Glue` (Default) and Apache `Iceberg` (https://iceberg.apache.org/).
 */
public data class FeatureGroupOfflineStoreConfig(
    public val dataCatalogConfig: FeatureGroupOfflineStoreConfigDataCatalogConfig? = null,
    public val disableGlueTableCreation: Boolean? = null,
    public val s3StorageConfig: FeatureGroupOfflineStoreConfigS3StorageConfig,
    public val tableFormat: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FeatureGroupOfflineStoreConfig):
            FeatureGroupOfflineStoreConfig = FeatureGroupOfflineStoreConfig(
            dataCatalogConfig = javaType.dataCatalogConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOfflineStoreConfigDataCatalogConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableGlueTableCreation = javaType.disableGlueTableCreation().map({ args0 -> args0 }).orElse(null),
            s3StorageConfig = javaType.s3StorageConfig().let({ args0 ->
                com.pulumi.aws.sagemaker.kotlin.outputs.FeatureGroupOfflineStoreConfigS3StorageConfig.Companion.toKotlin(args0)
            }),
            tableFormat = javaType.tableFormat().map({ args0 -> args0 }).orElse(null),
        )
    }
}
