@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property catalog The name of the Glue table catalog.
 * @property database The name of the Glue table database.
 * @property tableName The name of the Glue table.
 */
public data class FeatureGroupOfflineStoreConfigDataCatalogConfig(
    public val catalog: String? = null,
    public val database: String? = null,
    public val tableName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FeatureGroupOfflineStoreConfigDataCatalogConfig):
            FeatureGroupOfflineStoreConfigDataCatalogConfig =
            FeatureGroupOfflineStoreConfigDataCatalogConfig(
                catalog = javaType.catalog().map({ args0 -> args0 }).orElse(null),
                database = javaType.database().map({ args0 -> args0 }).orElse(null),
                tableName = javaType.tableName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
