@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
 */
public data class FeatureGroupOnlineStoreConfigSecurityConfig(
    public val kmsKeyId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FeatureGroupOnlineStoreConfigSecurityConfig):
            FeatureGroupOnlineStoreConfigSecurityConfig = FeatureGroupOnlineStoreConfigSecurityConfig(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
