@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property humanLoopActivationConditions A JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. For more information about how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html).
 */
public data class FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfig(
    public val humanLoopActivationConditions: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfig):
            FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfig =
            FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfig(
                humanLoopActivationConditions = javaType.humanLoopActivationConditions(),
            )
    }
}
