@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId The Amazon Key Management Service (KMS) key ARN for server-side encryption.
 * @property s3OutputPath The Amazon S3 path where the object containing human output will be made available.
 */
public data class FlowDefinitionOutputConfig(
    public val kmsKeyId: String? = null,
    public val s3OutputPath: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.FlowDefinitionOutputConfig):
            FlowDefinitionOutputConfig = FlowDefinitionOutputConfig(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            s3OutputPath = javaType.s3OutputPath(),
        )
    }
}
