@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getPrebuiltEcrImage.
 * @property dnsSuffix
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageTag
 * @property region
 * @property registryId Account ID containing the image. For example, `469771592824`.
 * @property registryPath Docker image URL. For example, `341280168497.dkr.ecr.ca-central-1.amazonaws.com/sagemaker-sparkml-serving:2.4`.
 * @property repositoryName
 */
public data class GetPrebuiltEcrImageResult(
    public val dnsSuffix: String? = null,
    public val id: String,
    public val imageTag: String? = null,
    public val region: String? = null,
    public val registryId: String,
    public val registryPath: String,
    public val repositoryName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.GetPrebuiltEcrImageResult):
            GetPrebuiltEcrImageResult = GetPrebuiltEcrImageResult(
            dnsSuffix = javaType.dnsSuffix().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            imageTag = javaType.imageTag().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            registryId = javaType.registryId(),
            registryPath = javaType.registryPath(),
            repositoryName = javaType.repositoryName(),
        )
    }
}
