@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property repositoryAccessMode Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). Allowed values are: `Platform` and `Vpc`.
 * @property repositoryAuthConfig Specifies an authentication configuration for the private docker registry where your model image is hosted. Specify a value for this property only if you specified Vpc as the value for the RepositoryAccessMode field, and the private Docker registry where the model image is hosted requires authentication. see Repository Auth Config.
 */
public data class ModelContainerImageConfig(
    public val repositoryAccessMode: String,
    public val repositoryAuthConfig: ModelContainerImageConfigRepositoryAuthConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.ModelContainerImageConfig):
            ModelContainerImageConfig = ModelContainerImageConfig(
            repositoryAccessMode = javaType.repositoryAccessMode(),
            repositoryAuthConfig = javaType.repositoryAuthConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.ModelContainerImageConfigRepositoryAuthConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
