@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property repositoryCredentialsProviderArn The Amazon Resource Name (ARN) of an AWS Lambda function that provides credentials to authenticate to the private Docker registry where your model image is hosted. For information about how to create an AWS Lambda function, see [Create a Lambda function with the console](https://docs.aws.amazon.com/lambda/latest/dg/getting-started-create-function.html) in the _AWS Lambda Developer Guide_.
 */
public data class ModelContainerImageConfigRepositoryAuthConfig(
    public val repositoryCredentialsProviderArn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.ModelContainerImageConfigRepositoryAuthConfig):
            ModelContainerImageConfigRepositoryAuthConfig =
            ModelContainerImageConfigRepositoryAuthConfig(
                repositoryCredentialsProviderArn = javaType.repositoryCredentialsProviderArn(),
            )
    }
}
