@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property monitoringJobDefinitionName The name of the monitoring job definition to schedule.
 * @property monitoringType The type of the monitoring job definition to schedule. Valid values are `DataQuality`, `ModelQuality`, `ModelBias` or `ModelExplainability`
 * @property scheduleConfig Configures the monitoring schedule. Fields are documented below.
 */
public data class MonitoringScheduleMonitoringScheduleConfig(
    public val monitoringJobDefinitionName: String,
    public val monitoringType: String,
    public val scheduleConfig: MonitoringScheduleMonitoringScheduleConfigScheduleConfig? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.MonitoringScheduleMonitoringScheduleConfig):
            MonitoringScheduleMonitoringScheduleConfig = MonitoringScheduleMonitoringScheduleConfig(
            monitoringJobDefinitionName = javaType.monitoringJobDefinitionName(),
            monitoringType = javaType.monitoringType(),
            scheduleConfig = javaType.scheduleConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.MonitoringScheduleMonitoringScheduleConfigScheduleConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
