@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property pathId The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path.
 * @property productId The ID of the product to provision.
 * @property provisioningArtifactId The ID of the provisioning artifact.
 * @property provisioningParameters A list of key value pairs that you specify when you provision a product. See Provisioning Parameter below.
 */
public data class ProjectServiceCatalogProvisioningDetails(
    public val pathId: String? = null,
    public val productId: String,
    public val provisioningArtifactId: String? = null,
    public val provisioningParameters:
    List<ProjectServiceCatalogProvisioningDetailsProvisioningParameter>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.ProjectServiceCatalogProvisioningDetails):
            ProjectServiceCatalogProvisioningDetails = ProjectServiceCatalogProvisioningDetails(
            pathId = javaType.pathId().map({ args0 -> args0 }).orElse(null),
            productId = javaType.productId(),
            provisioningArtifactId = javaType.provisioningArtifactId().map({ args0 -> args0 }).orElse(null),
            provisioningParameters = javaType.provisioningParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.ProjectServiceCatalogProvisioningDetailsProvisioningParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
