@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 */
public data class SpaceSpaceSettings(
    public val jupyterServerAppSettings: SpaceSpaceSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: SpaceSpaceSettingsKernelGatewayAppSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.SpaceSpaceSettings):
            SpaceSpaceSettings = SpaceSpaceSettings(
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.SpaceSpaceSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
