@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property canvasAppSettings The Canvas app settings. See Canvas App Settings below.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property rSessionAppSettings The RSession app settings. See RSession App Settings below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See RStudio Server Pro App Settings below.
 * @property securityGroups The security groups.
 * @property sharingSettings The sharing settings. See Sharing Settings below.
 * @property tensorBoardAppSettings The TensorBoard app settings. See TensorBoard App Settings below.
 */
public data class UserProfileUserSettings(
    public val canvasAppSettings: UserProfileUserSettingsCanvasAppSettings? = null,
    public val executionRole: String,
    public val jupyterServerAppSettings: UserProfileUserSettingsJupyterServerAppSettings? = null,
    public val kernelGatewayAppSettings: UserProfileUserSettingsKernelGatewayAppSettings? = null,
    public val rSessionAppSettings: UserProfileUserSettingsRSessionAppSettings? = null,
    public val rStudioServerProAppSettings: UserProfileUserSettingsRStudioServerProAppSettings? =
        null,
    public val securityGroups: List<String>? = null,
    public val sharingSettings: UserProfileUserSettingsSharingSettings? = null,
    public val tensorBoardAppSettings: UserProfileUserSettingsTensorBoardAppSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettings):
            UserProfileUserSettings = UserProfileUserSettings(
            canvasAppSettings = javaType.canvasAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            executionRole = javaType.executionRole(),
            jupyterServerAppSettings = javaType.jupyterServerAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsJupyterServerAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kernelGatewayAppSettings = javaType.kernelGatewayAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsKernelGatewayAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rSessionAppSettings = javaType.rSessionAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsRSessionAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rStudioServerProAppSettings = javaType.rStudioServerProAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsRStudioServerProAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
            sharingSettings = javaType.sharingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsSharingSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tensorBoardAppSettings = javaType.tensorBoardAppSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsTensorBoardAppSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
