@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property directDeploySettings The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
 * @property identityProviderOauthSettings The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
 * @property kendraSettings The settings for document querying. See Kendra Settings below.
 * @property modelRegisterSettings The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
 * @property timeSeriesForecastingSettings Time series forecast settings for the Canvas app. see Time Series Forecasting Settings below.
 * @property workspaceSettings The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
 */
public data class UserProfileUserSettingsCanvasAppSettings(
    public val directDeploySettings: UserProfileUserSettingsCanvasAppSettingsDirectDeploySettings? =
        null,
    public val identityProviderOauthSettings:
    List<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSetting>? = null,
    public val kendraSettings: UserProfileUserSettingsCanvasAppSettingsKendraSettings? = null,
    public val modelRegisterSettings: UserProfileUserSettingsCanvasAppSettingsModelRegisterSettings? =
        null,
    public val timeSeriesForecastingSettings:
    UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings? = null,
    public val workspaceSettings: UserProfileUserSettingsCanvasAppSettingsWorkspaceSettings? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettingsCanvasAppSettings):
            UserProfileUserSettingsCanvasAppSettings = UserProfileUserSettingsCanvasAppSettings(
            directDeploySettings = javaType.directDeploySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettingsDirectDeploySettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identityProviderOauthSettings = javaType.identityProviderOauthSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSetting.Companion.toKotlin(args0)
                })
            }),
            kendraSettings = javaType.kendraSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettingsKendraSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            modelRegisterSettings = javaType.modelRegisterSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettingsModelRegisterSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeSeriesForecastingSettings = javaType.timeSeriesForecastingSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            workspaceSettings = javaType.workspaceSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.UserProfileUserSettingsCanvasAppSettingsWorkspaceSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
