@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessStatus Indicates whether the current user has access to the RStudioServerPro app. Valid values are `ENABLED` and `DISABLED`.
 * @property userGroup The level of permissions that the user has within the RStudioServerPro app. This value defaults to `R_STUDIO_USER`. The `R_STUDIO_ADMIN` value allows the user access to the RStudio Administrative Dashboard. Valid values are `R_STUDIO_USER` and `R_STUDIO_ADMIN`.
 */
public data class UserProfileUserSettingsRStudioServerProAppSettings(
    public val accessStatus: String? = null,
    public val userGroup: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettingsRStudioServerProAppSettings):
            UserProfileUserSettingsRStudioServerProAppSettings =
            UserProfileUserSettingsRStudioServerProAppSettings(
                accessStatus = javaType.accessStatus().map({ args0 -> args0 }).orElse(null),
                userGroup = javaType.userGroup().map({ args0 -> args0 }).orElse(null),
            )
    }
}
