@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property notebookOutputOption Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
 * @property s3KmsKeyId When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
 * @property s3OutputPath When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
 */
public data class UserProfileUserSettingsSharingSettings(
    public val notebookOutputOption: String? = null,
    public val s3KmsKeyId: String? = null,
    public val s3OutputPath: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.UserProfileUserSettingsSharingSettings):
            UserProfileUserSettingsSharingSettings = UserProfileUserSettingsSharingSettings(
            notebookOutputOption = javaType.notebookOutputOption().map({ args0 -> args0 }).orElse(null),
            s3KmsKeyId = javaType.s3KmsKeyId().map({ args0 -> args0 }).orElse(null),
            s3OutputPath = javaType.s3OutputPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
