@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientId The client ID for your Amazon Cognito user pool.
 * @property userPool ID for your Amazon Cognito user pool.
 */
public data class WorkforceCognitoConfig(
    public val clientId: String,
    public val userPool: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkforceCognitoConfig):
            WorkforceCognitoConfig = WorkforceCognitoConfig(
            clientId = javaType.clientId(),
            userPool = javaType.userPool(),
        )
    }
}
