@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authorizationEndpoint The OIDC IdP authorization endpoint used to configure your private workforce.
 * @property clientId The OIDC IdP client ID used to configure your private workforce.
 * @property clientSecret The OIDC IdP client secret used to configure your private workforce.
 * @property issuer The OIDC IdP issuer used to configure your private workforce.
 * @property jwksUri The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private workforce.
 * @property logoutEndpoint The OIDC IdP logout endpoint used to configure your private workforce.
 * @property tokenEndpoint The OIDC IdP token endpoint used to configure your private workforce.
 * @property userInfoEndpoint The OIDC IdP user information endpoint used to configure your private workforce.
 */
public data class WorkforceOidcConfig(
    public val authorizationEndpoint: String,
    public val clientId: String,
    public val clientSecret: String,
    public val issuer: String,
    public val jwksUri: String,
    public val logoutEndpoint: String,
    public val tokenEndpoint: String,
    public val userInfoEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkforceOidcConfig):
            WorkforceOidcConfig = WorkforceOidcConfig(
            authorizationEndpoint = javaType.authorizationEndpoint(),
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret(),
            issuer = javaType.issuer(),
            jwksUri = javaType.jwksUri(),
            logoutEndpoint = javaType.logoutEndpoint(),
            tokenEndpoint = javaType.tokenEndpoint(),
            userInfoEndpoint = javaType.userInfoEndpoint(),
        )
    }
}
