@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cognitoMemberDefinition The Amazon Cognito user group that is part of the work team. See Cognito Member Definition details below.
 * @property oidcMemberDefinition A list user groups that exist in your OIDC Identity Provider (IdP). One to ten groups can be used to create a single private work team. See Cognito Member Definition details below.
 */
public data class WorkteamMemberDefinition(
    public val cognitoMemberDefinition: WorkteamMemberDefinitionCognitoMemberDefinition? = null,
    public val oidcMemberDefinition: WorkteamMemberDefinitionOidcMemberDefinition? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkteamMemberDefinition):
            WorkteamMemberDefinition = WorkteamMemberDefinition(
            cognitoMemberDefinition = javaType.cognitoMemberDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamMemberDefinitionCognitoMemberDefinition.Companion.toKotlin(args0)
                })
            }).orElse(null),
            oidcMemberDefinition = javaType.oidcMemberDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.sagemaker.kotlin.outputs.WorkteamMemberDefinitionOidcMemberDefinition.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
