@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientId An identifier for an application client. You must create the app client ID using Amazon Cognito.
 * @property userGroup An identifier for a user group.
 * @property userPool An identifier for a user pool. The user pool must be in the same region as the service that you are calling.
 */
public data class WorkteamMemberDefinitionCognitoMemberDefinition(
    public val clientId: String,
    public val userGroup: String,
    public val userPool: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.sagemaker.outputs.WorkteamMemberDefinitionCognitoMemberDefinition):
            WorkteamMemberDefinitionCognitoMemberDefinition =
            WorkteamMemberDefinitionCognitoMemberDefinition(
                clientId = javaType.clientId(),
                userGroup = javaType.userGroup(),
                userPool = javaType.userPool(),
            )
    }
}
