@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin

import com.pulumi.aws.scheduler.kotlin.outputs.ScheduleFlexibleTimeWindow
import com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTarget
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.scheduler.kotlin.outputs.ScheduleFlexibleTimeWindow.Companion.toKotlin as scheduleFlexibleTimeWindowToKotlin
import com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTarget.Companion.toKotlin as scheduleTargetToKotlin

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.aws.scheduler.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * Provides an EventBridge Scheduler Schedule resource.
 * You can find out more about EventBridge Scheduler in the [User Guide](https://docs.aws.amazon.com/scheduler/latest/UserGuide/what-is-scheduler.html).
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.scheduler.Schedule;
 * import com.pulumi.aws.scheduler.ScheduleArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Schedule("example", ScheduleArgs.builder()
 *             .groupName("default")
 *             .flexibleTimeWindow(ScheduleFlexibleTimeWindowArgs.builder()
 *                 .mode("OFF")
 *                 .build())
 *             .scheduleExpression("rate(1 hours)")
 *             .target(ScheduleTargetArgs.builder()
 *                 .arn(aws_sqs_queue.example().arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Universal Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.scheduler.Schedule;
 * import com.pulumi.aws.scheduler.ScheduleArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleQueue = new Queue("exampleQueue");
 *         var exampleSchedule = new Schedule("exampleSchedule", ScheduleArgs.builder()
 *             .flexibleTimeWindow(ScheduleFlexibleTimeWindowArgs.builder()
 *                 .mode("OFF")
 *                 .build())
 *             .scheduleExpression("rate(1 hours)")
 *             .target(ScheduleTargetArgs.builder()
 *                 .arn("arn:aws:scheduler:::aws-sdk:sqs:sendMessage")
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .input(exampleQueue.url().applyValue(url -> serializeJson(
 *                     jsonObject(
 *                         jsonProperty("MessageBody", "Greetings, programs!"),
 *                         jsonProperty("QueueUrl", url)
 *                     ))))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import schedules using the combination `group_name/name`. For example:
 * ```sh
 *  $ pulumi import aws:scheduler/schedule:Schedule example my-schedule-group/my-schedule
 * ```
 *
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.aws.scheduler.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * ARN of the SQS queue specified as the destination for the dead-letter queue.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Brief description of the schedule.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the end date you specify. EventBridge Scheduler ignores the end date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
     */
    public val endDate: Output<String>?
        get() = javaResource.endDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configures a time window during which EventBridge Scheduler invokes the schedule. Detailed below.
     */
    public val flexibleTimeWindow: Output<ScheduleFlexibleTimeWindow>
        get() = javaResource.flexibleTimeWindow().applyValue({ args0 ->
            args0.let({ args0 ->
                scheduleFlexibleTimeWindowToKotlin(args0)
            })
        })

    /**
     * Name of the schedule group to associate with this schedule. When omitted, the `default` schedule group is used.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * ARN for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the schedule. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * Defines when the schedule runs. Read more in [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html).
     */
    public val scheduleExpression: Output<String>
        get() = javaResource.scheduleExpression().applyValue({ args0 -> args0 })

    /**
     * Timezone in which the scheduling expression is evaluated. Defaults to `UTC`. Example: `Australia/Sydney`.
     */
    public val scheduleExpressionTimezone: Output<String>?
        get() = javaResource.scheduleExpressionTimezone().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the start date you specify. EventBridge Scheduler ignores the start date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
     */
    public val startDate: Output<String>?
        get() = javaResource.startDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies whether the schedule is enabled or disabled. One of: `ENABLED` (default), `DISABLED`.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configures the target of the schedule. Detailed below.
     * The following arguments are optional:
     */
    public val target: Output<ScheduleTarget>
        get() = javaResource.target().applyValue({ args0 ->
            args0.let({ args0 ->
                scheduleTargetToKotlin(args0)
            })
        })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.scheduler.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.aws.scheduler.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit):
    Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
