@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin

import com.pulumi.aws.scheduler.ScheduleArgs.builder
import com.pulumi.aws.scheduler.kotlin.inputs.ScheduleFlexibleTimeWindowArgs
import com.pulumi.aws.scheduler.kotlin.inputs.ScheduleFlexibleTimeWindowArgsBuilder
import com.pulumi.aws.scheduler.kotlin.inputs.ScheduleTargetArgs
import com.pulumi.aws.scheduler.kotlin.inputs.ScheduleTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides an EventBridge Scheduler Schedule resource.
 * You can find out more about EventBridge Scheduler in the [User Guide](https://docs.aws.amazon.com/scheduler/latest/UserGuide/what-is-scheduler.html).
 * > **Note:** EventBridge was formerly known as CloudWatch Events. The functionality is identical.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.scheduler.Schedule;
 * import com.pulumi.aws.scheduler.ScheduleArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Schedule("example", ScheduleArgs.builder()
 *             .groupName("default")
 *             .flexibleTimeWindow(ScheduleFlexibleTimeWindowArgs.builder()
 *                 .mode("OFF")
 *                 .build())
 *             .scheduleExpression("rate(1 hours)")
 *             .target(ScheduleTargetArgs.builder()
 *                 .arn(aws_sqs_queue.example().arn())
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ### Universal Target
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sqs.Queue;
 * import com.pulumi.aws.scheduler.Schedule;
 * import com.pulumi.aws.scheduler.ScheduleArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleFlexibleTimeWindowArgs;
 * import com.pulumi.aws.scheduler.inputs.ScheduleTargetArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleQueue = new Queue("exampleQueue");
 *         var exampleSchedule = new Schedule("exampleSchedule", ScheduleArgs.builder()
 *             .flexibleTimeWindow(ScheduleFlexibleTimeWindowArgs.builder()
 *                 .mode("OFF")
 *                 .build())
 *             .scheduleExpression("rate(1 hours)")
 *             .target(ScheduleTargetArgs.builder()
 *                 .arn("arn:aws:scheduler:::aws-sdk:sqs:sendMessage")
 *                 .roleArn(aws_iam_role.example().arn())
 *                 .input(exampleQueue.url().applyValue(url -> serializeJson(
 *                     jsonObject(
 *                         jsonProperty("MessageBody", "Greetings, programs!"),
 *                         jsonProperty("QueueUrl", url)
 *                     ))))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import schedules using the combination `group_name/name`. For example:
 * ```sh
 *  $ pulumi import aws:scheduler/schedule:Schedule example my-schedule-group/my-schedule
 * ```
 * @property description Brief description of the schedule.
 * @property endDate The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the end date you specify. EventBridge Scheduler ignores the end date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
 * @property flexibleTimeWindow Configures a time window during which EventBridge Scheduler invokes the schedule. Detailed below.
 * @property groupName Name of the schedule group to associate with this schedule. When omitted, the `default` schedule group is used.
 * @property kmsKeyArn ARN for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
 * @property name Name of the schedule. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property scheduleExpression Defines when the schedule runs. Read more in [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html).
 * @property scheduleExpressionTimezone Timezone in which the scheduling expression is evaluated. Defaults to `UTC`. Example: `Australia/Sydney`.
 * @property startDate The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the start date you specify. EventBridge Scheduler ignores the start date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
 * @property state Specifies whether the schedule is enabled or disabled. One of: `ENABLED` (default), `DISABLED`.
 * @property target Configures the target of the schedule. Detailed below.
 * The following arguments are optional:
 */
public data class ScheduleArgs(
    public val description: Output<String>? = null,
    public val endDate: Output<String>? = null,
    public val flexibleTimeWindow: Output<ScheduleFlexibleTimeWindowArgs>? = null,
    public val groupName: Output<String>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val scheduleExpression: Output<String>? = null,
    public val scheduleExpressionTimezone: Output<String>? = null,
    public val startDate: Output<String>? = null,
    public val state: Output<String>? = null,
    public val target: Output<ScheduleTargetArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.scheduler.ScheduleArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.ScheduleArgs =
        com.pulumi.aws.scheduler.ScheduleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .endDate(endDate?.applyValue({ args0 -> args0 }))
            .flexibleTimeWindow(
                flexibleTimeWindow?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression?.applyValue({ args0 -> args0 }))
            .scheduleExpressionTimezone(scheduleExpressionTimezone?.applyValue({ args0 -> args0 }))
            .startDate(startDate?.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var endDate: Output<String>? = null

    private var flexibleTimeWindow: Output<ScheduleFlexibleTimeWindowArgs>? = null

    private var groupName: Output<String>? = null

    private var kmsKeyArn: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    private var scheduleExpressionTimezone: Output<String>? = null

    private var startDate: Output<String>? = null

    private var state: Output<String>? = null

    private var target: Output<ScheduleTargetArgs>? = null

    /**
     * @param value Brief description of the schedule.
     */
    @JvmName("nlkfttojfqbyncfn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the end date you specify. EventBridge Scheduler ignores the end date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
     */
    @JvmName("dlcnguqxnbniiynk")
    public suspend fun endDate(`value`: Output<String>) {
        this.endDate = value
    }

    /**
     * @param value Configures a time window during which EventBridge Scheduler invokes the schedule. Detailed below.
     */
    @JvmName("lqxnpmgsuvkwfmbt")
    public suspend fun flexibleTimeWindow(`value`: Output<ScheduleFlexibleTimeWindowArgs>) {
        this.flexibleTimeWindow = value
    }

    /**
     * @param value Name of the schedule group to associate with this schedule. When omitted, the `default` schedule group is used.
     */
    @JvmName("rcdtmuutxroyuiqh")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value ARN for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     */
    @JvmName("nykqwyqbiioeyjnj")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value Name of the schedule. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("jjxqbyeysjuhibcb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("huqpcheyqtjpcdfn")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Defines when the schedule runs. Read more in [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html).
     */
    @JvmName("povpqniwkjscsdar")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value Timezone in which the scheduling expression is evaluated. Defaults to `UTC`. Example: `Australia/Sydney`.
     */
    @JvmName("yqfdnakbelsbbotj")
    public suspend fun scheduleExpressionTimezone(`value`: Output<String>) {
        this.scheduleExpressionTimezone = value
    }

    /**
     * @param value The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the start date you specify. EventBridge Scheduler ignores the start date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
     */
    @JvmName("gpwiackqjxqcixig")
    public suspend fun startDate(`value`: Output<String>) {
        this.startDate = value
    }

    /**
     * @param value Specifies whether the schedule is enabled or disabled. One of: `ENABLED` (default), `DISABLED`.
     */
    @JvmName("vtjlnllpfjbivads")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Configures the target of the schedule. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("wnbbcegitthrvwdr")
    public suspend fun target(`value`: Output<ScheduleTargetArgs>) {
        this.target = value
    }

    /**
     * @param value Brief description of the schedule.
     */
    @JvmName("scodemxkiqkponty")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The date, in UTC, before which the schedule can invoke its target. Depending on the schedule's recurrence expression, invocations might stop on, or before, the end date you specify. EventBridge Scheduler ignores the end date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
     */
    @JvmName("gnkmglsqtsvayikp")
    public suspend fun endDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endDate = mapped
    }

    /**
     * @param value Configures a time window during which EventBridge Scheduler invokes the schedule. Detailed below.
     */
    @JvmName("tksryoggvtxmnldg")
    public suspend fun flexibleTimeWindow(`value`: ScheduleFlexibleTimeWindowArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flexibleTimeWindow = mapped
    }

    /**
     * @param argument Configures a time window during which EventBridge Scheduler invokes the schedule. Detailed below.
     */
    @JvmName("miniddygggsfabtm")
    public suspend
    fun flexibleTimeWindow(argument: suspend ScheduleFlexibleTimeWindowArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleFlexibleTimeWindowArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.flexibleTimeWindow = mapped
    }

    /**
     * @param value Name of the schedule group to associate with this schedule. When omitted, the `default` schedule group is used.
     */
    @JvmName("wxpccknyhulkngpj")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value ARN for the customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt your data.
     */
    @JvmName("qdnwtvutxjssthcl")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value Name of the schedule. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("bamjsddiriacnndq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("ukesuagmkmpokldy")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Defines when the schedule runs. Read more in [Schedule types on EventBridge Scheduler](https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html).
     */
    @JvmName("tlttdeemihlbbive")
    public suspend fun scheduleExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value Timezone in which the scheduling expression is evaluated. Defaults to `UTC`. Example: `Australia/Sydney`.
     */
    @JvmName("mtpewwutcfjgxnjx")
    public suspend fun scheduleExpressionTimezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleExpressionTimezone = mapped
    }

    /**
     * @param value The date, in UTC, after which the schedule can begin invoking its target. Depending on the schedule's recurrence expression, invocations might occur on, or after, the start date you specify. EventBridge Scheduler ignores the start date for one-time schedules. Example: `2030-01-01T01:00:00Z`.
     */
    @JvmName("emkdarijotooexje")
    public suspend fun startDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startDate = mapped
    }

    /**
     * @param value Specifies whether the schedule is enabled or disabled. One of: `ENABLED` (default), `DISABLED`.
     */
    @JvmName("hsnriqsawfyunkwj")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Configures the target of the schedule. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("ajyrwtgnymkgwcfs")
    public suspend fun target(`value`: ScheduleTargetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param argument Configures the target of the schedule. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("hrylvopdkpwijdux")
    public suspend fun target(argument: suspend ScheduleTargetArgsBuilder.() -> Unit) {
        val toBeMapped = ScheduleTargetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.target = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        description = description,
        endDate = endDate,
        flexibleTimeWindow = flexibleTimeWindow,
        groupName = groupName,
        kmsKeyArn = kmsKeyArn,
        name = name,
        namePrefix = namePrefix,
        scheduleExpression = scheduleExpression,
        scheduleExpressionTimezone = scheduleExpressionTimezone,
        startDate = startDate,
        state = state,
        target = target,
    )
}
