@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetDeadLetterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn ARN of the SQS queue specified as the destination for the dead-letter queue.
 */
public data class ScheduleTargetDeadLetterConfigArgs(
    public val arn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetDeadLetterConfigArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetDeadLetterConfigArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetDeadLetterConfigArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetDeadLetterConfigArgs].
 */
@PulumiTagMarker
public class ScheduleTargetDeadLetterConfigArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    /**
     * @param value ARN of the SQS queue specified as the destination for the dead-letter queue.
     */
    @JvmName("dffcpvuaaurnhlox")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value ARN of the SQS queue specified as the destination for the dead-letter queue.
     */
    @JvmName("javcmbchoisnhrlv")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    internal fun build(): ScheduleTargetDeadLetterConfigArgs = ScheduleTargetDeadLetterConfigArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
    )
}
