@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementConstraintArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expression A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance`. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon ECS Developer Guide.
 * @property type The type of constraint. One of: `distinctInstance`, `memberOf`.
 */
public data class ScheduleTargetEcsParametersPlacementConstraintArgs(
    public val expression: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementConstraintArgs> {
    override fun toJava():
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementConstraintArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementConstraintArgs.builder()
            .expression(expression?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetEcsParametersPlacementConstraintArgs].
 */
@PulumiTagMarker
public class ScheduleTargetEcsParametersPlacementConstraintArgsBuilder internal constructor() {
    private var expression: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance`. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon ECS Developer Guide.
     */
    @JvmName("nwfvvmybuoqjwihe")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value The type of constraint. One of: `distinctInstance`, `memberOf`.
     */
    @JvmName("wcwpiglmcrtvwsfn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is `distinctInstance`. For more information, see [Cluster query language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html) in the Amazon ECS Developer Guide.
     */
    @JvmName("jwnbuonbprvniret")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value The type of constraint. One of: `distinctInstance`, `memberOf`.
     */
    @JvmName("pppjnpqiknlyiesw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScheduleTargetEcsParametersPlacementConstraintArgs =
        ScheduleTargetEcsParametersPlacementConstraintArgs(
            expression = expression,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
