@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementStrategyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property field The field to apply the placement strategy against.
 * @property type The type of placement strategy. One of: `random`, `spread`, `binpack`.
 */
public data class ScheduleTargetEcsParametersPlacementStrategyArgs(
    public val `field`: Output<String>? = null,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementStrategyArgs> {
    override fun toJava():
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementStrategyArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetEcsParametersPlacementStrategyArgs.builder()
            .`field`(`field`?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetEcsParametersPlacementStrategyArgs].
 */
@PulumiTagMarker
public class ScheduleTargetEcsParametersPlacementStrategyArgsBuilder internal constructor() {
    private var `field`: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The field to apply the placement strategy against.
     */
    @JvmName("hvxsjbpbhpmuubec")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value The type of placement strategy. One of: `random`, `spread`, `binpack`.
     */
    @JvmName("uttsfcjdlhwrumkr")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The field to apply the placement strategy against.
     */
    @JvmName("cleqcmbrpnkgxovc")
    public suspend fun `field`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value The type of placement strategy. One of: `random`, `spread`, `binpack`.
     */
    @JvmName("mapceyqvkwrjnegn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ScheduleTargetEcsParametersPlacementStrategyArgs =
        ScheduleTargetEcsParametersPlacementStrategyArgs(
            `field` = `field`,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
