@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetKinesisParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property partitionKey Specifies the shard to which EventBridge Scheduler sends the event. Up to 256 characters.
 */
public data class ScheduleTargetKinesisParametersArgs(
    public val partitionKey: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetKinesisParametersArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetKinesisParametersArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetKinesisParametersArgs.builder()
            .partitionKey(partitionKey.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetKinesisParametersArgs].
 */
@PulumiTagMarker
public class ScheduleTargetKinesisParametersArgsBuilder internal constructor() {
    private var partitionKey: Output<String>? = null

    /**
     * @param value Specifies the shard to which EventBridge Scheduler sends the event. Up to 256 characters.
     */
    @JvmName("rjwbqtgnnapimjol")
    public suspend fun partitionKey(`value`: Output<String>) {
        this.partitionKey = value
    }

    /**
     * @param value Specifies the shard to which EventBridge Scheduler sends the event. Up to 256 characters.
     */
    @JvmName("apiuaeyrmbigebab")
    public suspend fun partitionKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionKey = mapped
    }

    internal fun build(): ScheduleTargetKinesisParametersArgs = ScheduleTargetKinesisParametersArgs(
        partitionKey = partitionKey ?: throw PulumiNullFieldException("partitionKey"),
    )
}
