@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.inputs

import com.pulumi.aws.scheduler.inputs.ScheduleTargetRetryPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumEventAgeInSeconds Maximum amount of time, in seconds, to continue to make retry attempts. Ranges from `60` to `86400` (default).
 * @property maximumRetryAttempts Maximum number of retry attempts to make before the request fails. Ranges from `0` to `185` (default).
 */
public data class ScheduleTargetRetryPolicyArgs(
    public val maximumEventAgeInSeconds: Output<Int>? = null,
    public val maximumRetryAttempts: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.scheduler.inputs.ScheduleTargetRetryPolicyArgs> {
    override fun toJava(): com.pulumi.aws.scheduler.inputs.ScheduleTargetRetryPolicyArgs =
        com.pulumi.aws.scheduler.inputs.ScheduleTargetRetryPolicyArgs.builder()
            .maximumEventAgeInSeconds(maximumEventAgeInSeconds?.applyValue({ args0 -> args0 }))
            .maximumRetryAttempts(maximumRetryAttempts?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleTargetRetryPolicyArgs].
 */
@PulumiTagMarker
public class ScheduleTargetRetryPolicyArgsBuilder internal constructor() {
    private var maximumEventAgeInSeconds: Output<Int>? = null

    private var maximumRetryAttempts: Output<Int>? = null

    /**
     * @param value Maximum amount of time, in seconds, to continue to make retry attempts. Ranges from `60` to `86400` (default).
     */
    @JvmName("xdhcjhjyaqleqbpg")
    public suspend fun maximumEventAgeInSeconds(`value`: Output<Int>) {
        this.maximumEventAgeInSeconds = value
    }

    /**
     * @param value Maximum number of retry attempts to make before the request fails. Ranges from `0` to `185` (default).
     */
    @JvmName("cokfonkbdkmqiioe")
    public suspend fun maximumRetryAttempts(`value`: Output<Int>) {
        this.maximumRetryAttempts = value
    }

    /**
     * @param value Maximum amount of time, in seconds, to continue to make retry attempts. Ranges from `60` to `86400` (default).
     */
    @JvmName("mqonyetexuadbhmg")
    public suspend fun maximumEventAgeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumEventAgeInSeconds = mapped
    }

    /**
     * @param value Maximum number of retry attempts to make before the request fails. Ranges from `0` to `185` (default).
     */
    @JvmName("magwdooxpnblefff")
    public suspend fun maximumRetryAttempts(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumRetryAttempts = mapped
    }

    internal fun build(): ScheduleTargetRetryPolicyArgs = ScheduleTargetRetryPolicyArgs(
        maximumEventAgeInSeconds = maximumEventAgeInSeconds,
        maximumRetryAttempts = maximumRetryAttempts,
    )
}
