@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maximumWindowInMinutes Maximum time window during which a schedule can be invoked. Ranges from `1` to `1440` minutes.
 * @property mode Determines whether the schedule is invoked within a flexible time window. One of: `OFF`, `FLEXIBLE`.
 */
public data class ScheduleFlexibleTimeWindow(
    public val maximumWindowInMinutes: Int? = null,
    public val mode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleFlexibleTimeWindow):
            ScheduleFlexibleTimeWindow = ScheduleFlexibleTimeWindow(
            maximumWindowInMinutes = javaType.maximumWindowInMinutes().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode(),
        )
    }
}
