@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN of the target of this schedule, such as a SQS queue or ECS cluster. For universal targets, this is a [Service ARN specific to the target service](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#supported-universal-targets).
 * @property deadLetterConfig Information about an Amazon SQS queue that EventBridge Scheduler uses as a dead-letter queue for your schedule. If specified, EventBridge Scheduler delivers failed events that could not be successfully delivered to a target to the queue. Detailed below.
 * @property ecsParameters Templated target type for the Amazon ECS [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) API operation. Detailed below.
 * @property eventbridgeParameters Templated target type for the EventBridge [`PutEvents`](https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html) API operation. Detailed below.
 * @property input Text, or well-formed JSON, passed to the target. Read more in [Universal target](https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html).
 * @property kinesisParameters Templated target type for the Amazon Kinesis [`PutRecord`](https://docs.aws.amazon.com/kinesis/latest/APIReference/API_PutRecord.html) API operation. Detailed below.
 * @property retryPolicy Information about the retry policy settings. Detailed below.
 * @property roleArn ARN of the IAM role that EventBridge Scheduler will use for this target when the schedule is invoked. Read more in [Set up the execution role](https://docs.aws.amazon.com/scheduler/latest/UserGuide/setting-up.html#setting-up-execution-role).
 * The following arguments are optional:
 * @property sagemakerPipelineParameters Templated target type for the Amazon SageMaker [`StartPipelineExecution`](https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_StartPipelineExecution.html) API operation. Detailed below.
 * @property sqsParameters The templated target type for the Amazon SQS [`SendMessage`](https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_SendMessage.html) API operation. Detailed below.
 */
public data class ScheduleTarget(
    public val arn: String,
    public val deadLetterConfig: ScheduleTargetDeadLetterConfig? = null,
    public val ecsParameters: ScheduleTargetEcsParameters? = null,
    public val eventbridgeParameters: ScheduleTargetEventbridgeParameters? = null,
    public val input: String? = null,
    public val kinesisParameters: ScheduleTargetKinesisParameters? = null,
    public val retryPolicy: ScheduleTargetRetryPolicy? = null,
    public val roleArn: String,
    public val sagemakerPipelineParameters: ScheduleTargetSagemakerPipelineParameters? = null,
    public val sqsParameters: ScheduleTargetSqsParameters? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleTarget): ScheduleTarget =
            ScheduleTarget(
                arn = javaType.arn(),
                deadLetterConfig = javaType.deadLetterConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetDeadLetterConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ecsParameters = javaType.ecsParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetEcsParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                eventbridgeParameters = javaType.eventbridgeParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetEventbridgeParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                input = javaType.input().map({ args0 -> args0 }).orElse(null),
                kinesisParameters = javaType.kinesisParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetKinesisParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                retryPolicy = javaType.retryPolicy().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetRetryPolicy.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                roleArn = javaType.roleArn(),
                sagemakerPipelineParameters = javaType.sagemakerPipelineParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetSagemakerPipelineParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqsParameters = javaType.sqsParameters().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetSqsParameters.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
