@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property capacityProviderStrategies Up to `6` capacity provider strategies to use for the task. Detailed below.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task. For more information, see [Tagging Your Amazon ECS Resources](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html) in the Amazon ECS Developer Guide.
 * @property enableExecuteCommand Specifies whether to enable the execute command functionality for the containers in this task.
 * @property group Specifies an ECS task group for the task. At most 255 characters.
 * @property launchType Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. One of: `EC2`, `FARGATE`, `EXTERNAL`.
 * @property networkConfiguration Configures the networking associated with the task. Detailed below.
 * @property placementConstraints A set of up to 10 placement constraints to use for the task. Detailed below.
 * @property placementStrategies A set of up to 5 placement strategies. Detailed below.
 * @property platformVersion Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`.
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. One of: `TASK_DEFINITION`.
 * @property referenceId Reference ID to use for the task.
 * @property tags The metadata that you apply to the task. Each tag consists of a key and an optional value. For more information, see [`RunTask`](https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html) in the Amazon ECS API Reference.
 * @property taskCount The number of tasks to create. Ranges from `1` (default) to `10`.
 * @property taskDefinitionArn ARN of the task definition to use.
 * The following arguments are optional:
 */
public data class ScheduleTargetEcsParameters(
    public val capacityProviderStrategies: List<ScheduleTargetEcsParametersCapacityProviderStrategy>? =
        null,
    public val enableEcsManagedTags: Boolean? = null,
    public val enableExecuteCommand: Boolean? = null,
    public val group: String? = null,
    public val launchType: String? = null,
    public val networkConfiguration: ScheduleTargetEcsParametersNetworkConfiguration? = null,
    public val placementConstraints: List<ScheduleTargetEcsParametersPlacementConstraint>? = null,
    public val placementStrategies: List<ScheduleTargetEcsParametersPlacementStrategy>? = null,
    public val platformVersion: String? = null,
    public val propagateTags: String? = null,
    public val referenceId: String? = null,
    public val tags: Map<String, String>? = null,
    public val taskCount: Int? = null,
    public val taskDefinitionArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleTargetEcsParameters):
            ScheduleTargetEcsParameters = ScheduleTargetEcsParameters(
            capacityProviderStrategies = javaType.capacityProviderStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetEcsParametersCapacityProviderStrategy.Companion.toKotlin(args0)
                })
            }),
            enableEcsManagedTags = javaType.enableEcsManagedTags().map({ args0 -> args0 }).orElse(null),
            enableExecuteCommand = javaType.enableExecuteCommand().map({ args0 -> args0 }).orElse(null),
            group = javaType.group().map({ args0 -> args0 }).orElse(null),
            launchType = javaType.launchType().map({ args0 -> args0 }).orElse(null),
            networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetEcsParametersNetworkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            placementConstraints = javaType.placementConstraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetEcsParametersPlacementConstraint.Companion.toKotlin(args0)
                })
            }),
            placementStrategies = javaType.placementStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.scheduler.kotlin.outputs.ScheduleTargetEcsParametersPlacementStrategy.Companion.toKotlin(args0)
                })
            }),
            platformVersion = javaType.platformVersion().map({ args0 -> args0 }).orElse(null),
            propagateTags = javaType.propagateTags().map({ args0 -> args0 }).orElse(null),
            referenceId = javaType.referenceId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskCount = javaType.taskCount().map({ args0 -> args0 }).orElse(null),
            taskDefinitionArn = javaType.taskDefinitionArn(),
        )
    }
}
