@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property base How many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. Ranges from `0` (default) to `100000`.
 * @property capacityProvider Short name of the capacity provider.
 * @property weight Designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied. Ranges from from `0` to `1000`.
 */
public data class ScheduleTargetEcsParametersCapacityProviderStrategy(
    public val base: Int? = null,
    public val capacityProvider: String,
    public val weight: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleTargetEcsParametersCapacityProviderStrategy):
            ScheduleTargetEcsParametersCapacityProviderStrategy =
            ScheduleTargetEcsParametersCapacityProviderStrategy(
                base = javaType.base().map({ args0 -> args0 }).orElse(null),
                capacityProvider = javaType.capacityProvider(),
                weight = javaType.weight().map({ args0 -> args0 }).orElse(null),
            )
    }
}
