@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumEventAgeInSeconds Maximum amount of time, in seconds, to continue to make retry attempts. Ranges from `60` to `86400` (default).
 * @property maximumRetryAttempts Maximum number of retry attempts to make before the request fails. Ranges from `0` to `185` (default).
 */
public data class ScheduleTargetRetryPolicy(
    public val maximumEventAgeInSeconds: Int? = null,
    public val maximumRetryAttempts: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.scheduler.outputs.ScheduleTargetRetryPolicy):
            ScheduleTargetRetryPolicy = ScheduleTargetRetryPolicy(
            maximumEventAgeInSeconds = javaType.maximumEventAgeInSeconds().map({ args0 -> args0 }).orElse(null),
            maximumRetryAttempts = javaType.maximumRetryAttempts().map({ args0 -> args0 }).orElse(null),
        )
    }
}
